/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.prism.Graphics;
import com.sun.prism.shape.ShapeRep;

public class NGCircle
extends NGShape {
    static final float HALF_SQRT_HALF = 0.353f;
    private Ellipse2D ellipse = new Ellipse2D();
    private float cx;
    private float cy;

    public void updateCircle(float cx, float cy, float r) {
        this.ellipse.x = cx - r;
        this.ellipse.y = cy - r;
        this.ellipse.height = this.ellipse.width = r * 2.0f;
        this.cx = cx;
        this.cy = cy;
        this.geometryChanged();
    }

    @Override
    public Shape getShape() {
        return this.ellipse;
    }

    @Override
    protected boolean supportsOpaqueRegions() {
        return true;
    }

    @Override
    protected boolean hasOpaqueRegion() {
        return super.hasOpaqueRegion() && this.ellipse.width > 0.0f;
    }

    @Override
    protected RectBounds computeOpaqueRegion(RectBounds opaqueRegion) {
        float halfSquareLength = this.ellipse.width * 0.353f;
        return (RectBounds)opaqueRegion.deriveWithNewBounds(this.cx - halfSquareLength, this.cy - halfSquareLength, 0.0f, this.cx + halfSquareLength, this.cy + halfSquareLength, 0.0f);
    }

    @Override
    protected ShapeRep createShapeRep(Graphics g) {
        return g.getResourceFactory().createEllipseRep();
    }
}

